%------------------------------------------------------------------------------
% File     : ITP176^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer StandardRules problem prob_305__5389912_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : StandardRules/prob_305__5389912_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v7.5.0
% Syntax   : Number of formulae    :  324 ( 136 unt;  48 typ;   0 def)
%            Number of atoms       :  710 ( 268 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4770 (  66   ~;  10   |;  46   &;4346   @)
%                                         (   0 <=>; 302  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (   8 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  199 ( 199   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   49 (  46 usr;   5 con; 0-6 aty)
%            Number of variables   : 1206 (  92   ^;1043   !;  14   ?;1206   :)
%                                         (  57  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:22:48.434
%------------------------------------------------------------------------------
% Could-be-implicit typings (6)
thf(ty_t_LabeledGraphSemantics_OStandard__Constant,type,
    standard_Constant: $tType > $tType ).

thf(ty_t_LabeledGraphs_Olabeled__graph,type,
    labeled_graph: $tType > $tType > $tType ).

thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_tf_b,type,
    b: $tType ).

thf(ty_tf_a,type,
    a: $tType ).

% Explicit typings (42)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder__bot,type,
    order_bot: 
      !>[A: $tType] : $o ).

thf(sy_c_BNF__Greatest__Fixpoint_Ouniv,type,
    bNF_Greatest_univ: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( set @ B ) > A ) ).

thf(sy_c_Equiv__Relations_Ocongruent,type,
    equiv_congruent: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( A > B ) > $o ) ).

thf(sy_c_Equiv__Relations_Ocongruent2,type,
    equiv_congruent2: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ B @ B ) ) > ( A > B > C ) > $o ) ).

thf(sy_c_Equiv__Relations_Oequiv,type,
    equiv_equiv: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Equiv__Relations_Oproj,type,
    equiv_proj: 
      !>[B: $tType,A: $tType] : ( ( set @ ( product_prod @ B @ A ) ) > B > ( set @ A ) ) ).

thf(sy_c_Hilbert__Choice_OEps,type,
    hilbert_Eps: 
      !>[A: $tType] : ( ( A > $o ) > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_LabeledGraphSemantics_OStandard__Constant_OS__Idt,type,
    standard_S_Idt: 
      !>[V: $tType] : ( standard_Constant @ V ) ).

thf(sy_c_LabeledGraphSemantics_OgetRel,type,
    getRel: 
      !>[B: $tType,A: $tType] : ( B > ( labeled_graph @ B @ A ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_LabeledGraphs_Ograph__homomorphism,type,
    graph_homomorphism: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( labeled_graph @ A @ B ) > ( labeled_graph @ A @ C ) > ( set @ ( product_prod @ B @ C ) ) > $o ) ).

thf(sy_c_LabeledGraphs_Ograph__union,type,
    graph_union: 
      !>[A: $tType,B: $tType] : ( ( labeled_graph @ A @ B ) > ( labeled_graph @ A @ B ) > ( labeled_graph @ A @ B ) ) ).

thf(sy_c_LabeledGraphs_Olabeled__graph_OLG,type,
    labeled_LG: 
      !>[L: $tType,V: $tType] : ( ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) > ( set @ V ) > ( labeled_graph @ L @ V ) ) ).

thf(sy_c_LabeledGraphs_Olabeled__graph_Ocase__labeled__graph,type,
    labele1974067554_graph: 
      !>[L: $tType,V: $tType,A: $tType] : ( ( ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) > ( set @ V ) > A ) > ( labeled_graph @ L @ V ) > A ) ).

thf(sy_c_LabeledGraphs_Olabeled__graph_Oedges,type,
    labeled_edges: 
      !>[L: $tType,V: $tType] : ( ( labeled_graph @ L @ V ) > ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) ) ).

thf(sy_c_LabeledGraphs_Olabeled__graph_Overtices,type,
    labeled_vertices: 
      !>[L: $tType,V: $tType] : ( ( labeled_graph @ L @ V ) > ( set @ V ) ) ).

thf(sy_c_LabeledGraphs_Orestrict,type,
    restrict: 
      !>[A: $tType,B: $tType] : ( ( labeled_graph @ A @ B ) > ( labeled_graph @ A @ B ) ) ).

thf(sy_c_Order__Relation_Olinear__order__on,type,
    order_1409979114der_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__prod,type,
    product_rec_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T ) ).

thf(sy_c_Relation_OImage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ B ) ) > ( set @ A ) > ( set @ B ) ) ).

thf(sy_c_Relation_Oconverse,type,
    converse: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ B ) ) > ( set @ ( product_prod @ B @ A ) ) ) ).

thf(sy_c_Relation_Orefl__on,type,
    refl_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Relation_Ototal__on,type,
    total_on: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_G,type,
    g: labeled_graph @ ( standard_Constant @ a ) @ b ).

thf(sy_v_P____,type,
    p: b > b > $o ).

thf(sy_v_f____,type,
    f: b > b ).

thf(sy_v_x____,type,
    x: b ).

thf(sy_v_y____,type,
    y: b ).

% Relevant facts (256)
thf(fact_0__092_060open_062getRel_AS__Idt_AG_A_096_096_A_123x_125_A_061_AgetRel_AS__Idt_AG_A_096_096_A_123y_125_092_060close_062,axiom,
    ( ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ x @ ( bot_bot @ ( set @ b ) ) ) )
    = ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ y @ ( bot_bot @ ( set @ b ) ) ) ) ) ).

% \<open>getRel S_Idt G `` {x} = getRel S_Idt G `` {y}\<close>
thf(fact_1_assms_I1_J,axiom,
    ( g
    = ( restrict @ ( standard_Constant @ a ) @ b @ g ) ) ).

% assms(1)
thf(fact_2_P__eq,axiom,
    ! [X: b] :
      ( ( ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ X @ ( bot_bot @ ( set @ b ) ) ) )
       != ( bot_bot @ ( set @ b ) ) )
     => ( ( hilbert_Eps @ b @ ( p @ ( hilbert_Eps @ b @ ( p @ X ) ) ) )
        = ( hilbert_Eps @ b @ ( p @ X ) ) ) ) ).

% P_eq
thf(fact_3_P,axiom,
    ( p
    = ( ^ [X2: b,Y: b] : ( member @ b @ Y @ ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ X2 @ ( bot_bot @ ( set @ b ) ) ) ) ) ) ) ).

% P
thf(fact_4__092_060open_062_Ix_M_Ay_J_A_092_060in_062_AgetRel_AS__Idt_AG_092_060close_062,axiom,
    member @ ( product_prod @ b @ b ) @ ( product_Pair @ b @ b @ x @ y ) @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) ).

% \<open>(x, y) \<in> getRel S_Idt G\<close>
thf(fact_5__092_060open_062f_A_092_060equiv_062_A_092_060lambda_062x_O_Aif_AgetRel_AS__Idt_AG_A_096_096_A_123x_125_A_061_A_123_125_Athen_Ax_Aelse_AEps_A_IP_Ax_J_092_060close_062,axiom,
    ( f
    = ( ^ [X2: b] :
          ( if @ b
          @ ( ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ X2 @ ( bot_bot @ ( set @ b ) ) ) )
            = ( bot_bot @ ( set @ b ) ) )
          @ X2
          @ ( hilbert_Eps @ b @ ( p @ X2 ) ) ) ) ) ).

% \<open>f \<equiv> \<lambda>x. if getRel S_Idt G `` {x} = {} then x else Eps (P x)\<close>
thf(fact_6_singleton__conv,axiom,
    ! [A: $tType,A2: A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( X2 = A2 ) )
      = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singleton_conv
thf(fact_7_singleton__conv2,axiom,
    ! [A: $tType,A2: A] :
      ( ( collect @ A
        @ ( ^ [Y2: A,Z: A] : ( Y2 = Z )
          @ A2 ) )
      = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singleton_conv2
thf(fact_8_tuple__disj,axiom,
    ! [A: $tType,X3: A,Z2: A] :
      ( ( collect @ A
        @ ^ [Y: A] :
            ( ( Y = X3 )
            | ( Y = Z2 ) ) )
      = ( insert @ A @ X3 @ ( insert @ A @ Z2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% tuple_disj
thf(fact_9_Image__empty1,axiom,
    ! [B: $tType,A: $tType,X4: set @ B] :
      ( ( image @ B @ A @ ( bot_bot @ ( set @ ( product_prod @ B @ A ) ) ) @ X4 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Image_empty1
thf(fact_10_Image__empty2,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ B @ A )] :
      ( ( image @ B @ A @ R @ ( bot_bot @ ( set @ B ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Image_empty2
thf(fact_11_singletonI,axiom,
    ! [A: $tType,A2: A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_12_some__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( P @ A2 )
     => ( ! [X5: A] :
            ( ( P @ X5 )
           => ( X5 = A2 ) )
       => ( ( hilbert_Eps @ A @ P )
          = A2 ) ) ) ).

% some_equality
thf(fact_13_some__eq__trivial,axiom,
    ! [A: $tType,X3: A] :
      ( ( hilbert_Eps @ A
        @ ^ [Y: A] : ( Y = X3 ) )
      = X3 ) ).

% some_eq_trivial
thf(fact_14_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X2: A] :
            ~ ( P @ X2 ) ) ) ).

% empty_Collect_eq
thf(fact_15_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X2: A] :
            ~ ( P @ X2 ) ) ) ).

% Collect_empty_eq
thf(fact_16_all__not__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ! [X2: A] :
            ~ ( member @ A @ X2 @ A3 ) )
      = ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_17_empty__iff,axiom,
    ! [A: $tType,C2: A] :
      ~ ( member @ A @ C2 @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_18_insert__absorb2,axiom,
    ! [A: $tType,X3: A,A3: set @ A] :
      ( ( insert @ A @ X3 @ ( insert @ A @ X3 @ A3 ) )
      = ( insert @ A @ X3 @ A3 ) ) ).

% insert_absorb2
thf(fact_19_insert__iff,axiom,
    ! [A: $tType,A2: A,B2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B2 @ A3 ) )
      = ( ( A2 = B2 )
        | ( member @ A @ A2 @ A3 ) ) ) ).

% insert_iff
thf(fact_20_insertCI,axiom,
    ! [A: $tType,A2: A,B3: set @ A,B2: A] :
      ( ( ~ ( member @ A @ A2 @ B3 )
       => ( A2 = B2 ) )
     => ( member @ A @ A2 @ ( insert @ A @ B2 @ B3 ) ) ) ).

% insertCI
thf(fact_21_some__sym__eq__trivial,axiom,
    ! [A: $tType,X3: A] :
      ( ( hilbert_Eps @ A
        @ ( ^ [Y2: A,Z: A] : ( Y2 = Z )
          @ X3 ) )
      = X3 ) ).

% some_sym_eq_trivial
thf(fact_22_ImageI,axiom,
    ! [B: $tType,A: $tType,A2: A,B2: B,R2: set @ ( product_prod @ A @ B ),A3: set @ A] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ R2 )
     => ( ( member @ A @ A2 @ A3 )
       => ( member @ B @ B2 @ ( image @ A @ B @ R2 @ A3 ) ) ) ) ).

% ImageI
thf(fact_23_f,axiom,
    ( f
    = ( ^ [X2: b] :
          ( if @ b
          @ ( ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ X2 @ ( bot_bot @ ( set @ b ) ) ) )
            = ( bot_bot @ ( set @ b ) ) )
          @ X2
          @ ( hilbert_Eps @ b @ ( p @ X2 ) ) ) ) ) ).

% f
thf(fact_24_Image__singleton__iff,axiom,
    ! [A: $tType,B: $tType,B2: A,R2: set @ ( product_prod @ B @ A ),A2: B] :
      ( ( member @ A @ B2 @ ( image @ B @ A @ R2 @ ( insert @ B @ A2 @ ( bot_bot @ ( set @ B ) ) ) ) )
      = ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ A2 @ B2 ) @ R2 ) ) ).

% Image_singleton_iff
thf(fact_25_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ A @ B ),S: set @ ( product_prod @ A @ B )] :
      ( ( ( ^ [X2: A,Y: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X2 @ Y ) @ R ) )
        = ( ^ [X2: A,Y: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X2 @ Y ) @ S ) ) )
      = ( R = S ) ) ).

% pred_equals_eq2
thf(fact_26_rev__ImageI,axiom,
    ! [B: $tType,A: $tType,A2: A,A3: set @ A,B2: B,R2: set @ ( product_prod @ A @ B )] :
      ( ( member @ A @ A2 @ A3 )
     => ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ R2 )
       => ( member @ B @ B2 @ ( image @ A @ B @ R2 @ A3 ) ) ) ) ).

% rev_ImageI
thf(fact_27_Image__iff,axiom,
    ! [A: $tType,B: $tType,B2: A,R2: set @ ( product_prod @ B @ A ),A3: set @ B] :
      ( ( member @ A @ B2 @ ( image @ B @ A @ R2 @ A3 ) )
      = ( ? [X2: B] :
            ( ( member @ B @ X2 @ A3 )
            & ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ X2 @ B2 ) @ R2 ) ) ) ) ).

% Image_iff
thf(fact_28_ImageE,axiom,
    ! [A: $tType,B: $tType,B2: A,R2: set @ ( product_prod @ B @ A ),A3: set @ B] :
      ( ( member @ A @ B2 @ ( image @ B @ A @ R2 @ A3 ) )
     => ~ ! [X5: B] :
            ( ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ X5 @ B2 ) @ R2 )
           => ~ ( member @ B @ X5 @ A3 ) ) ) ).

% ImageE
thf(fact_29_Image__singleton,axiom,
    ! [B: $tType,A: $tType,R2: set @ ( product_prod @ B @ A ),A2: B] :
      ( ( image @ B @ A @ R2 @ ( insert @ B @ A2 @ ( bot_bot @ ( set @ B ) ) ) )
      = ( collect @ A
        @ ^ [B4: A] : ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ A2 @ B4 ) @ R2 ) ) ) ).

% Image_singleton
thf(fact_30_ex__in__conv,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ? [X2: A] : ( member @ A @ X2 @ A3 ) )
      = ( A3
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_31_equals0I,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ! [Y3: A] :
          ~ ( member @ A @ Y3 @ A3 )
     => ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_32_equals0D,axiom,
    ! [A: $tType,A3: set @ A,A2: A] :
      ( ( A3
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A2 @ A3 ) ) ).

% equals0D
thf(fact_33_emptyE,axiom,
    ! [A: $tType,A2: A] :
      ~ ( member @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_34_mk__disjoint__insert,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ? [B5: set @ A] :
          ( ( A3
            = ( insert @ A @ A2 @ B5 ) )
          & ~ ( member @ A @ A2 @ B5 ) ) ) ).

% mk_disjoint_insert
thf(fact_35_insert__commute,axiom,
    ! [A: $tType,X3: A,Y4: A,A3: set @ A] :
      ( ( insert @ A @ X3 @ ( insert @ A @ Y4 @ A3 ) )
      = ( insert @ A @ Y4 @ ( insert @ A @ X3 @ A3 ) ) ) ).

% insert_commute
thf(fact_36_insert__eq__iff,axiom,
    ! [A: $tType,A2: A,A3: set @ A,B2: A,B3: set @ A] :
      ( ~ ( member @ A @ A2 @ A3 )
     => ( ~ ( member @ A @ B2 @ B3 )
       => ( ( ( insert @ A @ A2 @ A3 )
            = ( insert @ A @ B2 @ B3 ) )
          = ( ( ( A2 = B2 )
             => ( A3 = B3 ) )
            & ( ( A2 != B2 )
             => ? [C3: set @ A] :
                  ( ( A3
                    = ( insert @ A @ B2 @ C3 ) )
                  & ~ ( member @ A @ B2 @ C3 )
                  & ( B3
                    = ( insert @ A @ A2 @ C3 ) )
                  & ~ ( member @ A @ A2 @ C3 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_37_insert__absorb,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ A3 )
     => ( ( insert @ A @ A2 @ A3 )
        = A3 ) ) ).

% insert_absorb
thf(fact_38_insert__ident,axiom,
    ! [A: $tType,X3: A,A3: set @ A,B3: set @ A] :
      ( ~ ( member @ A @ X3 @ A3 )
     => ( ~ ( member @ A @ X3 @ B3 )
       => ( ( ( insert @ A @ X3 @ A3 )
            = ( insert @ A @ X3 @ B3 ) )
          = ( A3 = B3 ) ) ) ) ).

% insert_ident
thf(fact_39_Set_Oset__insert,axiom,
    ! [A: $tType,X3: A,A3: set @ A] :
      ( ( member @ A @ X3 @ A3 )
     => ~ ! [B5: set @ A] :
            ( ( A3
              = ( insert @ A @ X3 @ B5 ) )
           => ( member @ A @ X3 @ B5 ) ) ) ).

% Set.set_insert
thf(fact_40_insertI2,axiom,
    ! [A: $tType,A2: A,B3: set @ A,B2: A] :
      ( ( member @ A @ A2 @ B3 )
     => ( member @ A @ A2 @ ( insert @ A @ B2 @ B3 ) ) ) ).

% insertI2
thf(fact_41_insertI1,axiom,
    ! [A: $tType,A2: A,B3: set @ A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ B3 ) ) ).

% insertI1
thf(fact_42_insertE,axiom,
    ! [A: $tType,A2: A,B2: A,A3: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B2 @ A3 ) )
     => ( ( A2 != B2 )
       => ( member @ A @ A2 @ A3 ) ) ) ).

% insertE
thf(fact_43_some__eq__imp,axiom,
    ! [A: $tType,P: A > $o,A2: A,B2: A] :
      ( ( ( hilbert_Eps @ A @ P )
        = A2 )
     => ( ( P @ B2 )
       => ( P @ A2 ) ) ) ).

% some_eq_imp
thf(fact_44_tfl__some,axiom,
    ! [A: $tType,P2: A > $o,X6: A] :
      ( ( P2 @ X6 )
     => ( P2 @ ( hilbert_Eps @ A @ P2 ) ) ) ).

% tfl_some
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member @ A @ X2 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
          = ( Q @ X5 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X5: A] :
          ( ( F @ X5 )
          = ( G @ X5 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_Eps__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
          = ( Q @ X5 ) )
     => ( ( hilbert_Eps @ A @ P )
        = ( hilbert_Eps @ A @ Q ) ) ) ).

% Eps_cong
thf(fact_50_someI,axiom,
    ! [A: $tType,P: A > $o,X3: A] :
      ( ( P @ X3 )
     => ( P @ ( hilbert_Eps @ A @ P ) ) ) ).

% someI
thf(fact_51_empty__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A
        @ ^ [X2: A] : $false ) ) ).

% empty_def
thf(fact_52_insert__Collect,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( insert @ A @ A2 @ ( collect @ A @ P ) )
      = ( collect @ A
        @ ^ [U: A] :
            ( ( U != A2 )
           => ( P @ U ) ) ) ) ).

% insert_Collect
thf(fact_53_insert__compr,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [A4: A,B6: set @ A] :
            ( collect @ A
            @ ^ [X2: A] :
                ( ( X2 = A4 )
                | ( member @ A @ X2 @ B6 ) ) ) ) ) ).

% insert_compr
thf(fact_54_some1__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ? [X6: A] :
          ( ( P @ X6 )
          & ! [Y3: A] :
              ( ( P @ Y3 )
             => ( Y3 = X6 ) ) )
     => ( ( P @ A2 )
       => ( ( hilbert_Eps @ A @ P )
          = A2 ) ) ) ).

% some1_equality
thf(fact_55_some__eq__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( P @ ( hilbert_Eps @ A @ P ) )
      = ( ? [X7: A] : ( P @ X7 ) ) ) ).

% some_eq_ex
thf(fact_56_someI2__bex,axiom,
    ! [A: $tType,A3: set @ A,P: A > $o,Q: A > $o] :
      ( ? [X6: A] :
          ( ( member @ A @ X6 @ A3 )
          & ( P @ X6 ) )
     => ( ! [X5: A] :
            ( ( ( member @ A @ X5 @ A3 )
              & ( P @ X5 ) )
           => ( Q @ X5 ) )
       => ( Q
          @ ( hilbert_Eps @ A
            @ ^ [X2: A] :
                ( ( member @ A @ X2 @ A3 )
                & ( P @ X2 ) ) ) ) ) ) ).

% someI2_bex
thf(fact_57_someI2__ex,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ? [X_1: A] : ( P @ X_1 )
     => ( ! [X5: A] :
            ( ( P @ X5 )
           => ( Q @ X5 ) )
       => ( Q @ ( hilbert_Eps @ A @ P ) ) ) ) ).

% someI2_ex
thf(fact_58_someI__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ? [X_1: A] : ( P @ X_1 )
     => ( P @ ( hilbert_Eps @ A @ P ) ) ) ).

% someI_ex
thf(fact_59_someI2,axiom,
    ! [A: $tType,P: A > $o,A2: A,Q: A > $o] :
      ( ( P @ A2 )
     => ( ! [X5: A] :
            ( ( P @ X5 )
           => ( Q @ X5 ) )
       => ( Q @ ( hilbert_Eps @ A @ P ) ) ) ) ).

% someI2
thf(fact_60_singleton__inject,axiom,
    ! [A: $tType,A2: A,B2: A] :
      ( ( ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A2 = B2 ) ) ).

% singleton_inject
thf(fact_61_insert__not__empty,axiom,
    ! [A: $tType,A2: A,A3: set @ A] :
      ( ( insert @ A @ A2 @ A3 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_62_doubleton__eq__iff,axiom,
    ! [A: $tType,A2: A,B2: A,C2: A,D: A] :
      ( ( ( insert @ A @ A2 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C2 @ ( insert @ A @ D @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A2 = C2 )
          & ( B2 = D ) )
        | ( ( A2 = D )
          & ( B2 = C2 ) ) ) ) ).

% doubleton_eq_iff
thf(fact_63_singleton__iff,axiom,
    ! [A: $tType,B2: A,A2: A] :
      ( ( member @ A @ B2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B2 = A2 ) ) ).

% singleton_iff
thf(fact_64_singletonD,axiom,
    ! [A: $tType,B2: A,A2: A] :
      ( ( member @ A @ B2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B2 = A2 ) ) ).

% singletonD
thf(fact_65_Collect__conv__if2,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X2: A] :
                ( ( A2 = X2 )
                & ( P @ X2 ) ) )
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      & ( ~ ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X2: A] :
                ( ( A2 = X2 )
                & ( P @ X2 ) ) )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Collect_conv_if2
thf(fact_66_Collect__conv__if,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X2: A] :
                ( ( X2 = A2 )
                & ( P @ X2 ) ) )
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      & ( ~ ( P @ A2 )
       => ( ( collect @ A
            @ ^ [X2: A] :
                ( ( X2 = A2 )
                & ( P @ X2 ) ) )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Collect_conv_if
thf(fact_67_some__in__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( member @ A
        @ ( hilbert_Eps @ A
          @ ^ [X2: A] : ( member @ A @ X2 @ A3 ) )
        @ A3 )
      = ( A3
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% some_in_eq
thf(fact_68_congr_I1_J,axiom,
    ! [X: b,Y5: b,L2: standard_Constant @ a] :
      ( ( member @ ( product_prod @ b @ b ) @ ( product_Pair @ b @ b @ X @ Y5 ) @ ( getRel @ ( standard_Constant @ a ) @ b @ L2 @ g ) )
     => ( equiv_congruent @ b @ ( set @ b ) @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g )
        @ ^ [V2: b] : ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ L2 @ g ) @ ( insert @ b @ V2 @ ( bot_bot @ ( set @ b ) ) ) ) ) ) ).

% congr(1)
thf(fact_69_vert__P,axiom,
    ! [X3: b] :
      ( ( member @ b @ X3 @ ( labeled_vertices @ ( standard_Constant @ a ) @ b @ g ) )
     => ( member @ ( product_prod @ b @ b ) @ ( product_Pair @ b @ b @ X3 @ ( hilbert_Eps @ b @ ( p @ X3 ) ) ) @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) ) ) ).

% vert_P
thf(fact_70__092_060open_062_IS__Idt_M_Ax_M_Ay_J_A_092_060in_062_Aedges_AG_092_060close_062,axiom,
    member @ ( product_prod @ ( standard_Constant @ a ) @ ( product_prod @ b @ b ) ) @ ( product_Pair @ ( standard_Constant @ a ) @ ( product_prod @ b @ b ) @ ( standard_S_Idt @ a ) @ ( product_Pair @ b @ b @ x @ y ) ) @ ( labeled_edges @ ( standard_Constant @ a ) @ b @ g ) ).

% \<open>(S_Idt, x, y) \<in> edges G\<close>
thf(fact_71_restrict__idemp,axiom,
    ! [B: $tType,A: $tType,X3: labeled_graph @ A @ B] :
      ( ( restrict @ A @ B @ ( restrict @ A @ B @ X3 ) )
      = ( restrict @ A @ B @ X3 ) ) ).

% restrict_idemp
thf(fact_72_r2,axiom,
    ! [X3: b] :
      ( ( ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ X3 @ ( bot_bot @ ( set @ b ) ) ) )
        = ( bot_bot @ ( set @ b ) ) )
      = ( ~ ( member @ b @ X3 @ ( labeled_vertices @ ( standard_Constant @ a ) @ b @ g ) ) ) ) ).

% r2
thf(fact_73_r1,axiom,
    ! [X3: b] :
      ( ( member @ b @ X3 @ ( labeled_vertices @ ( standard_Constant @ a ) @ b @ g ) )
      = ( p @ X3 @ X3 ) ) ).

% r1
thf(fact_74_congr_I2_J,axiom,
    ! [X: b,Y5: b,L2: standard_Constant @ a] :
      ( ( member @ ( product_prod @ b @ b ) @ ( product_Pair @ b @ b @ X @ Y5 ) @ ( getRel @ ( standard_Constant @ a ) @ b @ L2 @ g ) )
     => ( equiv_congruent @ b @ ( set @ b ) @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g )
        @ ^ [V2: b] : ( image @ b @ b @ ( converse @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ L2 @ g ) ) @ ( insert @ b @ V2 @ ( bot_bot @ ( set @ b ) ) ) ) ) ) ).

% congr(2)
thf(fact_75_the__elem__eq,axiom,
    ! [A: $tType,X3: A] :
      ( ( the_elem @ A @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) )
      = X3 ) ).

% the_elem_eq
thf(fact_76_bot__apply,axiom,
    ! [C: $tType,D2: $tType] :
      ( ( bot @ C )
     => ( ( bot_bot @ ( D2 > C ) )
        = ( ^ [X2: D2] : ( bot_bot @ C ) ) ) ) ).

% bot_apply
thf(fact_77_prod_Oinject,axiom,
    ! [A: $tType,B: $tType,X1: A,X22: B,Y1: A,Y22: B] :
      ( ( ( product_Pair @ A @ B @ X1 @ X22 )
        = ( product_Pair @ A @ B @ Y1 @ Y22 ) )
      = ( ( X1 = Y1 )
        & ( X22 = Y22 ) ) ) ).

% prod.inject
thf(fact_78_old_Oprod_Oinject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A5: A,B7: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A5 @ B7 ) )
      = ( ( A2 = A5 )
        & ( B2 = B7 ) ) ) ).

% old.prod.inject
thf(fact_79_converse__inject,axiom,
    ! [A: $tType,B: $tType,R2: set @ ( product_prod @ B @ A ),S2: set @ ( product_prod @ B @ A )] :
      ( ( ( converse @ B @ A @ R2 )
        = ( converse @ B @ A @ S2 ) )
      = ( R2 = S2 ) ) ).

% converse_inject
thf(fact_80_converse__converse,axiom,
    ! [B: $tType,A: $tType,R2: set @ ( product_prod @ A @ B )] :
      ( ( converse @ B @ A @ ( converse @ A @ B @ R2 ) )
      = R2 ) ).

% converse_converse
thf(fact_81_converse__iff,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,R2: set @ ( product_prod @ B @ A )] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ ( converse @ B @ A @ R2 ) )
      = ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ B2 @ A2 ) @ R2 ) ) ).

% converse_iff
thf(fact_82_vertices__restrict,axiom,
    ! [A: $tType,B: $tType,G2: labeled_graph @ B @ A] :
      ( ( labeled_vertices @ B @ A @ ( restrict @ B @ A @ G2 ) )
      = ( labeled_vertices @ B @ A @ G2 ) ) ).

% vertices_restrict
thf(fact_83_converse__empty,axiom,
    ! [B: $tType,A: $tType] :
      ( ( converse @ B @ A @ ( bot_bot @ ( set @ ( product_prod @ B @ A ) ) ) )
      = ( bot_bot @ ( set @ ( product_prod @ A @ B ) ) ) ) ).

% converse_empty
thf(fact_84__092_060open_062_092_060And_062x_O_Ax_A_092_060in_062_Avertices_AG_A_092_060Longrightarrow_062_A_Ix_M_Ax_J_A_092_060in_062_AgetRel_AS__Idt_AG_092_060close_062,axiom,
    ! [X3: b] :
      ( ( member @ b @ X3 @ ( labeled_vertices @ ( standard_Constant @ a ) @ b @ g ) )
     => ( member @ ( product_prod @ b @ b ) @ ( product_Pair @ b @ b @ X3 @ X3 ) @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) ) ) ).

% \<open>\<And>x. x \<in> vertices G \<Longrightarrow> (x, x) \<in> getRel S_Idt G\<close>
thf(fact_85_labeled__graph_Oexpand,axiom,
    ! [V: $tType,L: $tType,Labeled_graph: labeled_graph @ L @ V,Labeled_graph2: labeled_graph @ L @ V] :
      ( ( ( ( labeled_edges @ L @ V @ Labeled_graph )
          = ( labeled_edges @ L @ V @ Labeled_graph2 ) )
        & ( ( labeled_vertices @ L @ V @ Labeled_graph )
          = ( labeled_vertices @ L @ V @ Labeled_graph2 ) ) )
     => ( Labeled_graph = Labeled_graph2 ) ) ).

% labeled_graph.expand
thf(fact_86_converse_Oinducts,axiom,
    ! [B: $tType,A: $tType,X1: B,X22: A,R2: set @ ( product_prod @ A @ B ),P: B > A > $o] :
      ( ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ X1 @ X22 ) @ ( converse @ A @ B @ R2 ) )
     => ( ! [A6: A,B8: B] :
            ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A6 @ B8 ) @ R2 )
           => ( P @ B8 @ A6 ) )
       => ( P @ X1 @ X22 ) ) ) ).

% converse.inducts
thf(fact_87_converse_Ointros,axiom,
    ! [B: $tType,A: $tType,A2: A,B2: B,R2: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ R2 )
     => ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ B2 @ A2 ) @ ( converse @ A @ B @ R2 ) ) ) ).

% converse.intros
thf(fact_88_converse_Osimps,axiom,
    ! [B: $tType,A: $tType,A1: B,A22: A,R2: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ A1 @ A22 ) @ ( converse @ A @ B @ R2 ) )
      = ( ? [A4: A,B4: B] :
            ( ( A1 = B4 )
            & ( A22 = A4 )
            & ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A4 @ B4 ) @ R2 ) ) ) ) ).

% converse.simps
thf(fact_89_converse_Ocases,axiom,
    ! [B: $tType,A: $tType,A1: B,A22: A,R2: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ A1 @ A22 ) @ ( converse @ A @ B @ R2 ) )
     => ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A22 @ A1 ) @ R2 ) ) ).

% converse.cases
thf(fact_90_converseE,axiom,
    ! [A: $tType,B: $tType,Yx: product_prod @ A @ B,R2: set @ ( product_prod @ B @ A )] :
      ( ( member @ ( product_prod @ A @ B ) @ Yx @ ( converse @ B @ A @ R2 ) )
     => ~ ! [X5: B,Y3: A] :
            ( ( Yx
              = ( product_Pair @ A @ B @ Y3 @ X5 ) )
           => ~ ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ X5 @ Y3 ) @ R2 ) ) ) ).

% converseE
thf(fact_91_converseD,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,R2: set @ ( product_prod @ B @ A )] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ ( converse @ B @ A @ R2 ) )
     => ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ B2 @ A2 ) @ R2 ) ) ).

% converseD
thf(fact_92_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_93_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X2: A] : ( member @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_94_bot__empty__eq2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot_bot @ ( A > B > $o ) )
      = ( ^ [X2: A,Y: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X2 @ Y ) @ ( bot_bot @ ( set @ ( product_prod @ A @ B ) ) ) ) ) ) ).

% bot_empty_eq2
thf(fact_95_old_Oprod_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,Prod: product_prod @ A @ B] :
      ( ! [A6: A,B8: B] : ( P @ ( product_Pair @ A @ B @ A6 @ B8 ) )
     => ( P @ Prod ) ) ).

% old.prod.inducts
thf(fact_96_old_Oprod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y4: product_prod @ A @ B] :
      ~ ! [A6: A,B8: B] :
          ( Y4
         != ( product_Pair @ A @ B @ A6 @ B8 ) ) ).

% old.prod.exhaust
thf(fact_97_prod__induct7,axiom,
    ! [G3: $tType,F2: $tType,E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) ) ) ) > $o,X3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) ) )] :
      ( ! [A6: A,B8: B,C4: C,D3: D2,E2: E,F3: F2,G4: G3] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) ) @ B8 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) @ C4 @ ( product_Pair @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) @ D3 @ ( product_Pair @ E @ ( product_prod @ F2 @ G3 ) @ E2 @ ( product_Pair @ F2 @ G3 @ F3 @ G4 ) ) ) ) ) ) )
     => ( P @ X3 ) ) ).

% prod_induct7
thf(fact_98_prod__induct6,axiom,
    ! [F2: $tType,E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) ) ) > $o,X3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) )] :
      ( ! [A6: A,B8: B,C4: C,D3: D2,E2: E,F3: F2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) @ B8 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) @ C4 @ ( product_Pair @ D2 @ ( product_prod @ E @ F2 ) @ D3 @ ( product_Pair @ E @ F2 @ E2 @ F3 ) ) ) ) ) )
     => ( P @ X3 ) ) ).

% prod_induct6
thf(fact_99_prod__induct5,axiom,
    ! [E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) ) > $o,X3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) )] :
      ( ! [A6: A,B8: B,C4: C,D3: D2,E2: E] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) @ B8 @ ( product_Pair @ C @ ( product_prod @ D2 @ E ) @ C4 @ ( product_Pair @ D2 @ E @ D3 @ E2 ) ) ) ) )
     => ( P @ X3 ) ) ).

% prod_induct5
thf(fact_100_prod__induct4,axiom,
    ! [D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) ) > $o,X3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) )] :
      ( ! [A6: A,B8: B,C4: C,D3: D2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ D2 ) @ B8 @ ( product_Pair @ C @ D2 @ C4 @ D3 ) ) ) )
     => ( P @ X3 ) ) ).

% prod_induct4
thf(fact_101_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ C ) ) > $o,X3: product_prod @ A @ ( product_prod @ B @ C )] :
      ( ! [A6: A,B8: B,C4: C] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ C ) @ A6 @ ( product_Pair @ B @ C @ B8 @ C4 ) ) )
     => ( P @ X3 ) ) ).

% prod_induct3
thf(fact_102_prod__cases7,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,F2: $tType,G3: $tType,Y4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) ) )] :
      ~ ! [A6: A,B8: B,C4: C,D3: D2,E2: E,F3: F2,G4: G3] :
          ( Y4
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) ) @ B8 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) ) @ C4 @ ( product_Pair @ D2 @ ( product_prod @ E @ ( product_prod @ F2 @ G3 ) ) @ D3 @ ( product_Pair @ E @ ( product_prod @ F2 @ G3 ) @ E2 @ ( product_Pair @ F2 @ G3 @ F3 @ G4 ) ) ) ) ) ) ) ).

% prod_cases7
thf(fact_103_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,F2: $tType,Y4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) )] :
      ~ ! [A6: A,B8: B,C4: C,D3: D2,E2: E,F3: F2] :
          ( Y4
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) ) @ B8 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F2 ) ) @ C4 @ ( product_Pair @ D2 @ ( product_prod @ E @ F2 ) @ D3 @ ( product_Pair @ E @ F2 @ E2 @ F3 ) ) ) ) ) ) ).

% prod_cases6
thf(fact_104_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,Y4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) )] :
      ~ ! [A6: A,B8: B,C4: C,D3: D2,E2: E] :
          ( Y4
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) @ B8 @ ( product_Pair @ C @ ( product_prod @ D2 @ E ) @ C4 @ ( product_Pair @ D2 @ E @ D3 @ E2 ) ) ) ) ) ).

% prod_cases5
thf(fact_105_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,Y4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) )] :
      ~ ! [A6: A,B8: B,C4: C,D3: D2] :
          ( Y4
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) @ A6 @ ( product_Pair @ B @ ( product_prod @ C @ D2 ) @ B8 @ ( product_Pair @ C @ D2 @ C4 @ D3 ) ) ) ) ).

% prod_cases4
thf(fact_106_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y4: product_prod @ A @ ( product_prod @ B @ C )] :
      ~ ! [A6: A,B8: B,C4: C] :
          ( Y4
         != ( product_Pair @ A @ ( product_prod @ B @ C ) @ A6 @ ( product_Pair @ B @ C @ B8 @ C4 ) ) ) ).

% prod_cases3
thf(fact_107_Pair__inject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A5: A,B7: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A5 @ B7 ) )
     => ~ ( ( A2 = A5 )
         => ( B2 != B7 ) ) ) ).

% Pair_inject
thf(fact_108_prod__cases,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,P3: product_prod @ A @ B] :
      ( ! [A6: A,B8: B] : ( P @ ( product_Pair @ A @ B @ A6 @ B8 ) )
     => ( P @ P3 ) ) ).

% prod_cases
thf(fact_109_surj__pair,axiom,
    ! [A: $tType,B: $tType,P3: product_prod @ A @ B] :
    ? [X5: A,Y3: B] :
      ( P3
      = ( product_Pair @ A @ B @ X5 @ Y3 ) ) ).

% surj_pair
thf(fact_110_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X2: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_111_local_Orefl,axiom,
    refl_on @ b @ ( labeled_vertices @ ( standard_Constant @ a ) @ b @ g ) @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) ).

% local.refl
thf(fact_112_equiv,axiom,
    equiv_equiv @ b @ ( labeled_vertices @ ( standard_Constant @ a ) @ b @ g ) @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) ).

% equiv
thf(fact_113_getRel__dom_I1_J,axiom,
    ! [B: $tType,A: $tType,G2: labeled_graph @ A @ B,A2: B,B2: B,L3: A] :
      ( ( G2
        = ( restrict @ A @ B @ G2 ) )
     => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ A2 @ B2 ) @ ( getRel @ A @ B @ L3 @ G2 ) )
       => ( member @ B @ A2 @ ( labeled_vertices @ A @ B @ G2 ) ) ) ) ).

% getRel_dom(1)
thf(fact_114_getRel__dom_I2_J,axiom,
    ! [B: $tType,A: $tType,G2: labeled_graph @ A @ B,A2: B,B2: B,L3: A] :
      ( ( G2
        = ( restrict @ A @ B @ G2 ) )
     => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ A2 @ B2 ) @ ( getRel @ A @ B @ L3 @ G2 ) )
       => ( member @ B @ B2 @ ( labeled_vertices @ A @ B @ G2 ) ) ) ) ).

% getRel_dom(2)
thf(fact_115_old_Oprod_Orec,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > B > T,A2: A,B2: B] :
      ( ( product_rec_prod @ A @ B @ T @ F1 @ ( product_Pair @ A @ B @ A2 @ B2 ) )
      = ( F1 @ A2 @ B2 ) ) ).

% old.prod.rec
thf(fact_116_is__singleton__the__elem,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A7: set @ A] :
            ( A7
            = ( insert @ A @ ( the_elem @ A @ A7 ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_the_elem
thf(fact_117_refl__on__converse,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A )] :
      ( ( refl_on @ A @ A3 @ ( converse @ A @ A @ R2 ) )
      = ( refl_on @ A @ A3 @ R2 ) ) ).

% refl_on_converse
thf(fact_118_is__singletonI,axiom,
    ! [A: $tType,X3: A] : ( is_singleton @ A @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_119_bot2E,axiom,
    ! [A: $tType,B: $tType,X3: A,Y4: B] :
      ~ ( bot_bot @ ( A > B > $o ) @ X3 @ Y4 ) ).

% bot2E
thf(fact_120_refl__onD,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),A2: A] :
      ( ( refl_on @ A @ A3 @ R2 )
     => ( ( member @ A @ A2 @ A3 )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A2 ) @ R2 ) ) ) ).

% refl_onD
thf(fact_121_refl__onD1,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),X3: A,Y4: A] :
      ( ( refl_on @ A @ A3 @ R2 )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y4 ) @ R2 )
       => ( member @ A @ X3 @ A3 ) ) ) ).

% refl_onD1
thf(fact_122_refl__onD2,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),X3: A,Y4: A] :
      ( ( refl_on @ A @ A3 @ R2 )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y4 ) @ R2 )
       => ( member @ A @ Y4 @ A3 ) ) ) ).

% refl_onD2
thf(fact_123_refl__on__empty,axiom,
    ! [A: $tType] : ( refl_on @ A @ ( bot_bot @ ( set @ A ) ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ).

% refl_on_empty
thf(fact_124_is__singletonI_H,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( A3
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X5: A,Y3: A] :
            ( ( member @ A @ X5 @ A3 )
           => ( ( member @ A @ Y3 @ A3 )
             => ( X5 = Y3 ) ) )
       => ( is_singleton @ A @ A3 ) ) ) ).

% is_singletonI'
thf(fact_125_refl__on__singleton,axiom,
    ! [A: $tType,X3: A] : ( refl_on @ A @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) @ ( insert @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ) ).

% refl_on_singleton
thf(fact_126_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A7: set @ A] :
          ? [X2: A] :
            ( A7
            = ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_127_is__singletonE,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( is_singleton @ A @ A3 )
     => ~ ! [X5: A] :
            ( A3
           != ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_128_equiv__class__eq__iff,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),X3: A,Y4: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y4 ) @ R2 )
        = ( ( ( image @ A @ A @ R2 @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) )
            = ( image @ A @ A @ R2 @ ( insert @ A @ Y4 @ ( bot_bot @ ( set @ A ) ) ) ) )
          & ( member @ A @ X3 @ A3 )
          & ( member @ A @ Y4 @ A3 ) ) ) ) ).

% equiv_class_eq_iff
thf(fact_129_eq__equiv__class__iff,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),X3: A,Y4: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( member @ A @ X3 @ A3 )
       => ( ( member @ A @ Y4 @ A3 )
         => ( ( ( image @ A @ A @ R2 @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) )
              = ( image @ A @ A @ R2 @ ( insert @ A @ Y4 @ ( bot_bot @ ( set @ A ) ) ) ) )
            = ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y4 ) @ R2 ) ) ) ) ) ).

% eq_equiv_class_iff
thf(fact_130_equiv__class__eq,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),A2: A,B2: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R2 )
       => ( ( image @ A @ A @ R2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
          = ( image @ A @ A @ R2 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% equiv_class_eq
thf(fact_131_eq__equiv__class,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A ),A2: A,B2: A,A3: set @ A] :
      ( ( ( image @ A @ A @ R2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( image @ A @ A @ R2 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) )
     => ( ( equiv_equiv @ A @ A3 @ R2 )
       => ( ( member @ A @ B2 @ A3 )
         => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R2 ) ) ) ) ).

% eq_equiv_class
thf(fact_132_congruentI,axiom,
    ! [B: $tType,A: $tType,R2: set @ ( product_prod @ A @ A ),F: A > B] :
      ( ! [Y3: A,Z3: A] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ Z3 ) @ R2 )
         => ( ( F @ Y3 )
            = ( F @ Z3 ) ) )
     => ( equiv_congruent @ A @ B @ R2 @ F ) ) ).

% congruentI
thf(fact_133_congruentD,axiom,
    ! [B: $tType,A: $tType,R2: set @ ( product_prod @ A @ A ),F: A > B,Y4: A,Z2: A] :
      ( ( equiv_congruent @ A @ B @ R2 @ F )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y4 @ Z2 ) @ R2 )
       => ( ( F @ Y4 )
          = ( F @ Z2 ) ) ) ) ).

% congruentD
thf(fact_134_equiv__class__self,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),A2: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( member @ A @ A2 @ A3 )
       => ( member @ A @ A2 @ ( image @ A @ A @ R2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% equiv_class_self
thf(fact_135_Collect__empty__eq__bot,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( P
        = ( bot_bot @ ( A > $o ) ) ) ) ).

% Collect_empty_eq_bot
thf(fact_136_graph__single,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,C2: B] :
      ( ( labeled_LG @ A @ B @ ( insert @ ( product_prod @ A @ ( product_prod @ B @ B ) ) @ ( product_Pair @ A @ ( product_prod @ B @ B ) @ A2 @ ( product_Pair @ B @ B @ B2 @ C2 ) ) @ ( bot_bot @ ( set @ ( product_prod @ A @ ( product_prod @ B @ B ) ) ) ) ) @ ( insert @ B @ B2 @ ( insert @ B @ C2 @ ( bot_bot @ ( set @ B ) ) ) ) )
      = ( restrict @ A @ B @ ( labeled_LG @ A @ B @ ( insert @ ( product_prod @ A @ ( product_prod @ B @ B ) ) @ ( product_Pair @ A @ ( product_prod @ B @ B ) @ A2 @ ( product_Pair @ B @ B @ B2 @ C2 ) ) @ ( bot_bot @ ( set @ ( product_prod @ A @ ( product_prod @ B @ B ) ) ) ) ) @ ( insert @ B @ B2 @ ( insert @ B @ C2 @ ( bot_bot @ ( set @ B ) ) ) ) ) ) ) ).

% graph_single
thf(fact_137_refl__on__domain,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),A2: A,B2: A] :
      ( ( refl_on @ A @ A3 @ R2 )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R2 )
       => ( ( member @ A @ A2 @ A3 )
          & ( member @ A @ B2 @ A3 ) ) ) ) ).

% refl_on_domain
thf(fact_138_total__on__singleton,axiom,
    ! [A: $tType,X3: A] : ( total_on @ A @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) @ ( insert @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ) ).

% total_on_singleton
thf(fact_139_labeled__graph_Oinject,axiom,
    ! [L: $tType,V: $tType,X1: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X22: set @ V,Y1: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),Y22: set @ V] :
      ( ( ( labeled_LG @ L @ V @ X1 @ X22 )
        = ( labeled_LG @ L @ V @ Y1 @ Y22 ) )
      = ( ( X1 = Y1 )
        & ( X22 = Y22 ) ) ) ).

% labeled_graph.inject
thf(fact_140_total__on__converse,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A )] :
      ( ( total_on @ A @ A3 @ ( converse @ A @ A @ R2 ) )
      = ( total_on @ A @ A3 @ R2 ) ) ).

% total_on_converse
thf(fact_141_labeled__graph_Ocollapse,axiom,
    ! [V: $tType,L: $tType,Labeled_graph: labeled_graph @ L @ V] :
      ( ( labeled_LG @ L @ V @ ( labeled_edges @ L @ V @ Labeled_graph ) @ ( labeled_vertices @ L @ V @ Labeled_graph ) )
      = Labeled_graph ) ).

% labeled_graph.collapse
thf(fact_142_graph__empty__e,axiom,
    ! [A: $tType,B: $tType,V3: set @ B] :
      ( ( labeled_LG @ A @ B @ ( bot_bot @ ( set @ ( product_prod @ A @ ( product_prod @ B @ B ) ) ) ) @ V3 )
      = ( restrict @ A @ B @ ( labeled_LG @ A @ B @ ( bot_bot @ ( set @ ( product_prod @ A @ ( product_prod @ B @ B ) ) ) ) @ V3 ) ) ) ).

% graph_empty_e
thf(fact_143_total__on__def,axiom,
    ! [A: $tType] :
      ( ( total_on @ A )
      = ( ^ [A7: set @ A,R3: set @ ( product_prod @ A @ A )] :
          ! [X2: A] :
            ( ( member @ A @ X2 @ A7 )
           => ! [Y: A] :
                ( ( member @ A @ Y @ A7 )
               => ( ( X2 != Y )
                 => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X2 @ Y ) @ R3 )
                    | ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y @ X2 ) @ R3 ) ) ) ) ) ) ) ).

% total_on_def
thf(fact_144_total__onI,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A )] :
      ( ! [X5: A,Y3: A] :
          ( ( member @ A @ X5 @ A3 )
         => ( ( member @ A @ Y3 @ A3 )
           => ( ( X5 != Y3 )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X5 @ Y3 ) @ R2 )
                | ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ X5 ) @ R2 ) ) ) ) )
     => ( total_on @ A @ A3 @ R2 ) ) ).

% total_onI
thf(fact_145_total__on__empty,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] : ( total_on @ A @ ( bot_bot @ ( set @ A ) ) @ R2 ) ).

% total_on_empty
thf(fact_146_labeled__graph_Osel_I2_J,axiom,
    ! [L: $tType,V: $tType,X1: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X22: set @ V] :
      ( ( labeled_vertices @ L @ V @ ( labeled_LG @ L @ V @ X1 @ X22 ) )
      = X22 ) ).

% labeled_graph.sel(2)
thf(fact_147_labeled__graph_Oexhaust,axiom,
    ! [L: $tType,V: $tType,Y4: labeled_graph @ L @ V] :
      ~ ! [X12: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X23: set @ V] :
          ( Y4
         != ( labeled_LG @ L @ V @ X12 @ X23 ) ) ).

% labeled_graph.exhaust
thf(fact_148_labeled__graph_Oinduct,axiom,
    ! [V: $tType,L: $tType,P: ( labeled_graph @ L @ V ) > $o,Labeled_graph: labeled_graph @ L @ V] :
      ( ! [X1a: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X2a: set @ V] : ( P @ ( labeled_LG @ L @ V @ X1a @ X2a ) )
     => ( P @ Labeled_graph ) ) ).

% labeled_graph.induct
thf(fact_149_labeled__graph_Osel_I1_J,axiom,
    ! [V: $tType,L: $tType,X1: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X22: set @ V] :
      ( ( labeled_edges @ L @ V @ ( labeled_LG @ L @ V @ X1 @ X22 ) )
      = X1 ) ).

% labeled_graph.sel(1)
thf(fact_150_labeled__graph_Oexhaust__sel,axiom,
    ! [V: $tType,L: $tType,Labeled_graph: labeled_graph @ L @ V] :
      ( Labeled_graph
      = ( labeled_LG @ L @ V @ ( labeled_edges @ L @ V @ Labeled_graph ) @ ( labeled_vertices @ L @ V @ Labeled_graph ) ) ) ).

% labeled_graph.exhaust_sel
thf(fact_151_linear__order__on__singleton,axiom,
    ! [A: $tType,X3: A] : ( order_1409979114der_on @ A @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) @ ( insert @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ) ).

% linear_order_on_singleton
thf(fact_152_labeled__graph_Osplit__sel,axiom,
    ! [A: $tType,V: $tType,L: $tType,P: A > $o,F: ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) > ( set @ V ) > A,Labeled_graph: labeled_graph @ L @ V] :
      ( ( P @ ( labele1974067554_graph @ L @ V @ A @ F @ Labeled_graph ) )
      = ( ( Labeled_graph
          = ( labeled_LG @ L @ V @ ( labeled_edges @ L @ V @ Labeled_graph ) @ ( labeled_vertices @ L @ V @ Labeled_graph ) ) )
       => ( P @ ( F @ ( labeled_edges @ L @ V @ Labeled_graph ) @ ( labeled_vertices @ L @ V @ Labeled_graph ) ) ) ) ) ).

% labeled_graph.split_sel
thf(fact_153_labeled__graph_Osplit__sel__asm,axiom,
    ! [A: $tType,V: $tType,L: $tType,P: A > $o,F: ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) > ( set @ V ) > A,Labeled_graph: labeled_graph @ L @ V] :
      ( ( P @ ( labele1974067554_graph @ L @ V @ A @ F @ Labeled_graph ) )
      = ( ~ ( ( Labeled_graph
              = ( labeled_LG @ L @ V @ ( labeled_edges @ L @ V @ Labeled_graph ) @ ( labeled_vertices @ L @ V @ Labeled_graph ) ) )
            & ~ ( P @ ( F @ ( labeled_edges @ L @ V @ Labeled_graph ) @ ( labeled_vertices @ L @ V @ Labeled_graph ) ) ) ) ) ) ).

% labeled_graph.split_sel_asm
thf(fact_154_graph__homomorphism__empty,axiom,
    ! [B: $tType,C: $tType,A: $tType,G2: labeled_graph @ A @ C,F: set @ ( product_prod @ B @ C )] :
      ( ( graph_homomorphism @ A @ B @ C @ ( labeled_LG @ A @ B @ ( bot_bot @ ( set @ ( product_prod @ A @ ( product_prod @ B @ B ) ) ) ) @ ( bot_bot @ ( set @ B ) ) ) @ G2 @ F )
      = ( ( F
          = ( bot_bot @ ( set @ ( product_prod @ B @ C ) ) ) )
        & ( G2
          = ( restrict @ A @ C @ G2 ) ) ) ) ).

% graph_homomorphism_empty
thf(fact_155_linear__order__on__converse,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A )] :
      ( ( order_1409979114der_on @ A @ A3 @ ( converse @ A @ A @ R2 ) )
      = ( order_1409979114der_on @ A @ A3 @ R2 ) ) ).

% linear_order_on_converse
thf(fact_156_labeled__graph_Ocase__distrib,axiom,
    ! [A: $tType,B: $tType,V: $tType,L: $tType,H: A > B,F: ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) > ( set @ V ) > A,Labeled_graph: labeled_graph @ L @ V] :
      ( ( H @ ( labele1974067554_graph @ L @ V @ A @ F @ Labeled_graph ) )
      = ( labele1974067554_graph @ L @ V @ B
        @ ^ [X13: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X24: set @ V] : ( H @ ( F @ X13 @ X24 ) )
        @ Labeled_graph ) ) ).

% labeled_graph.case_distrib
thf(fact_157_labeled__graph_Ocase,axiom,
    ! [L: $tType,A: $tType,V: $tType,F: ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) > ( set @ V ) > A,X1: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X22: set @ V] :
      ( ( labele1974067554_graph @ L @ V @ A @ F @ ( labeled_LG @ L @ V @ X1 @ X22 ) )
      = ( F @ X1 @ X22 ) ) ).

% labeled_graph.case
thf(fact_158_edges__def,axiom,
    ! [V: $tType,L: $tType] :
      ( ( labeled_edges @ L @ V )
      = ( labele1974067554_graph @ L @ V @ ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) )
        @ ^ [X13: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X24: set @ V] : X13 ) ) ).

% edges_def
thf(fact_159_vertices__def,axiom,
    ! [V: $tType,L: $tType] :
      ( ( labeled_vertices @ L @ V )
      = ( labele1974067554_graph @ L @ V @ ( set @ V )
        @ ^ [X13: set @ ( product_prod @ L @ ( product_prod @ V @ V ) ),X24: set @ V] : X24 ) ) ).

% vertices_def
thf(fact_160_lnear__order__on__empty,axiom,
    ! [A: $tType] : ( order_1409979114der_on @ A @ ( bot_bot @ ( set @ A ) ) @ ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) ) ).

% lnear_order_on_empty
thf(fact_161_labeled__graph_Ocase__eq__if,axiom,
    ! [A: $tType,V: $tType,L: $tType] :
      ( ( labele1974067554_graph @ L @ V @ A )
      = ( ^ [F4: ( set @ ( product_prod @ L @ ( product_prod @ V @ V ) ) ) > ( set @ V ) > A,Labeled_graph3: labeled_graph @ L @ V] : ( F4 @ ( labeled_edges @ L @ V @ Labeled_graph3 ) @ ( labeled_vertices @ L @ V @ Labeled_graph3 ) ) ) ) ).

% labeled_graph.case_eq_if
thf(fact_162_congruent2__implies__congruent,axiom,
    ! [B: $tType,C: $tType,A: $tType,A3: set @ A,R1: set @ ( product_prod @ A @ A ),R22: set @ ( product_prod @ B @ B ),F: A > B > C,A2: A] :
      ( ( equiv_equiv @ A @ A3 @ R1 )
     => ( ( equiv_congruent2 @ A @ B @ C @ R1 @ R22 @ F )
       => ( ( member @ A @ A2 @ A3 )
         => ( equiv_congruent @ B @ C @ R22 @ ( F @ A2 ) ) ) ) ) ).

% congruent2_implies_congruent
thf(fact_163_proj__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( equiv_proj @ B @ A )
      = ( ^ [R3: set @ ( product_prod @ B @ A ),X2: B] : ( image @ B @ A @ R3 @ ( insert @ B @ X2 @ ( bot_bot @ ( set @ B ) ) ) ) ) ) ).

% proj_def
thf(fact_164_equiv__class__subset,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),A2: A,B2: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R2 )
       => ( ord_less_eq @ ( set @ A ) @ ( image @ A @ A @ R2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) @ ( image @ A @ A @ R2 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% equiv_class_subset
thf(fact_165_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X3: A] : ( ord_less_eq @ A @ X3 @ X3 ) ) ).

% order_refl
thf(fact_166_subset__antisym,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B3 )
     => ( ( ord_less_eq @ ( set @ A ) @ B3 @ A3 )
       => ( A3 = B3 ) ) ) ).

% subset_antisym
thf(fact_167_subsetI,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A] :
      ( ! [X5: A] :
          ( ( member @ A @ X5 @ A3 )
         => ( member @ A @ X5 @ B3 ) )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ B3 ) ) ).

% subsetI
thf(fact_168_converse__mono,axiom,
    ! [A: $tType,B: $tType,R2: set @ ( product_prod @ B @ A ),S2: set @ ( product_prod @ B @ A )] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ ( converse @ B @ A @ R2 ) @ ( converse @ B @ A @ S2 ) )
      = ( ord_less_eq @ ( set @ ( product_prod @ B @ A ) ) @ R2 @ S2 ) ) ).

% converse_mono
thf(fact_169_empty__subsetI,axiom,
    ! [A: $tType,A3: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A3 ) ).

% empty_subsetI
thf(fact_170_subset__empty,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ ( bot_bot @ ( set @ A ) ) )
      = ( A3
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_empty
thf(fact_171_insert__subset,axiom,
    ! [A: $tType,X3: A,A3: set @ A,B3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ X3 @ A3 ) @ B3 )
      = ( ( member @ A @ X3 @ B3 )
        & ( ord_less_eq @ ( set @ A ) @ A3 @ B3 ) ) ) ).

% insert_subset
thf(fact_172_singleton__insert__inj__eq_H,axiom,
    ! [A: $tType,A2: A,A3: set @ A,B2: A] :
      ( ( ( insert @ A @ A2 @ A3 )
        = ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( A2 = B2 )
        & ( ord_less_eq @ ( set @ A ) @ A3 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq'
thf(fact_173_singleton__insert__inj__eq,axiom,
    ! [A: $tType,B2: A,A2: A,A3: set @ A] :
      ( ( ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ A2 @ A3 ) )
      = ( ( A2 = B2 )
        & ( ord_less_eq @ ( set @ A ) @ A3 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq
thf(fact_174_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( A2 = B2 ) ) ) ) ).

% dual_order.antisym
thf(fact_175_dual__order_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y2: A,Z: A] : ( Y2 = Z ) )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less_eq @ A @ B4 @ A4 )
              & ( ord_less_eq @ A @ A4 @ B4 ) ) ) ) ) ).

% dual_order.eq_iff
thf(fact_176_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C2 @ B2 )
           => ( ord_less_eq @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_177_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: A > A > $o,A2: A,B2: A] :
          ( ! [A6: A,B8: A] :
              ( ( ord_less_eq @ A @ A6 @ B8 )
             => ( P @ A6 @ B8 ) )
         => ( ! [A6: A,B8: A] :
                ( ( P @ B8 @ A6 )
               => ( P @ A6 @ B8 ) )
           => ( P @ A2 @ B2 ) ) ) ) ).

% linorder_wlog
thf(fact_178_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_179_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X3: A,Y4: A,Z2: A] :
          ( ( ord_less_eq @ A @ X3 @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ Z2 )
           => ( ord_less_eq @ A @ X3 @ Z2 ) ) ) ) ).

% order_trans
thf(fact_180_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ A2 )
           => ( A2 = B2 ) ) ) ) ).

% order_class.order.antisym
thf(fact_181_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( B2 = C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_le_eq_trans
thf(fact_182_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( A2 = B2 )
         => ( ( ord_less_eq @ A @ B2 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_eq_le_trans
thf(fact_183_order__class_Oorder_Oeq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y2: A,Z: A] : ( Y2 = Z ) )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less_eq @ A @ A4 @ B4 )
              & ( ord_less_eq @ A @ B4 @ A4 ) ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_184_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Y4: A,X3: A] :
          ( ( ord_less_eq @ A @ Y4 @ X3 )
         => ( ( ord_less_eq @ A @ X3 @ Y4 )
            = ( X3 = Y4 ) ) ) ) ).

% antisym_conv
thf(fact_185_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X3: A,Y4: A,Z2: A] :
          ( ( ( ord_less_eq @ A @ X3 @ Y4 )
           => ~ ( ord_less_eq @ A @ Y4 @ Z2 ) )
         => ( ( ( ord_less_eq @ A @ Y4 @ X3 )
             => ~ ( ord_less_eq @ A @ X3 @ Z2 ) )
           => ( ( ( ord_less_eq @ A @ X3 @ Z2 )
               => ~ ( ord_less_eq @ A @ Z2 @ Y4 ) )
             => ( ( ( ord_less_eq @ A @ Z2 @ Y4 )
                 => ~ ( ord_less_eq @ A @ Y4 @ X3 ) )
               => ( ( ( ord_less_eq @ A @ Y4 @ Z2 )
                   => ~ ( ord_less_eq @ A @ Z2 @ X3 ) )
                 => ~ ( ( ord_less_eq @ A @ Z2 @ X3 )
                     => ~ ( ord_less_eq @ A @ X3 @ Y4 ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_186_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% order.trans
thf(fact_187_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X3: A,Y4: A] :
          ( ~ ( ord_less_eq @ A @ X3 @ Y4 )
         => ( ord_less_eq @ A @ Y4 @ X3 ) ) ) ).

% le_cases
thf(fact_188_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A )
     => ! [X3: A,Y4: A] :
          ( ( X3 = Y4 )
         => ( ord_less_eq @ A @ X3 @ Y4 ) ) ) ).

% eq_refl
thf(fact_189_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X3: A,Y4: A] :
          ( ( ord_less_eq @ A @ X3 @ Y4 )
          | ( ord_less_eq @ A @ Y4 @ X3 ) ) ) ).

% linear
thf(fact_190_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [X3: A,Y4: A] :
          ( ( ord_less_eq @ A @ X3 @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ X3 )
           => ( X3 = Y4 ) ) ) ) ).

% antisym
thf(fact_191_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ( ( ^ [Y2: A,Z: A] : ( Y2 = Z ) )
        = ( ^ [X2: A,Y: A] :
              ( ( ord_less_eq @ A @ X2 @ Y )
              & ( ord_less_eq @ A @ Y @ X2 ) ) ) ) ) ).

% eq_iff
thf(fact_192_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A2: A,B2: A,F: A > B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ( F @ B2 )
              = C2 )
           => ( ! [X5: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X5 @ Y3 )
                 => ( ord_less_eq @ B @ ( F @ X5 ) @ ( F @ Y3 ) ) )
             => ( ord_less_eq @ B @ ( F @ A2 ) @ C2 ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_193_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B )
        & ( ord @ A ) )
     => ! [A2: A,F: B > A,B2: B,C2: B] :
          ( ( A2
            = ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C2 )
           => ( ! [X5: B,Y3: B] :
                  ( ( ord_less_eq @ B @ X5 @ Y3 )
                 => ( ord_less_eq @ A @ ( F @ X5 ) @ ( F @ Y3 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C2 ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_194_order__subst2,axiom,
    ! [A: $tType,C: $tType] :
      ( ( ( order @ C )
        & ( order @ A ) )
     => ! [A2: A,B2: A,F: A > C,C2: C] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C @ ( F @ B2 ) @ C2 )
           => ( ! [X5: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X5 @ Y3 )
                 => ( ord_less_eq @ C @ ( F @ X5 ) @ ( F @ Y3 ) ) )
             => ( ord_less_eq @ C @ ( F @ A2 ) @ C2 ) ) ) ) ) ).

% order_subst2
thf(fact_195_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B )
        & ( order @ A ) )
     => ! [A2: A,F: B > A,B2: B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C2 )
           => ( ! [X5: B,Y3: B] :
                  ( ( ord_less_eq @ B @ X5 @ Y3 )
                 => ( ord_less_eq @ A @ ( F @ X5 ) @ ( F @ Y3 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C2 ) ) ) ) ) ) ).

% order_subst1
thf(fact_196_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F4: A > B,G5: A > B] :
            ! [X2: A] : ( ord_less_eq @ B @ ( F4 @ X2 ) @ ( G5 @ X2 ) ) ) ) ) ).

% le_fun_def
thf(fact_197_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F: A > B,G: A > B] :
          ( ! [X5: A] : ( ord_less_eq @ B @ ( F @ X5 ) @ ( G @ X5 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G ) ) ) ).

% le_funI
thf(fact_198_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F: A > B,G: A > B,X3: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funE
thf(fact_199_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B )
     => ! [F: A > B,G: A > B,X3: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ).

% le_funD
thf(fact_200_Image__mono,axiom,
    ! [B: $tType,A: $tType,R4: set @ ( product_prod @ A @ B ),R2: set @ ( product_prod @ A @ B ),A8: set @ A,A3: set @ A] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ R4 @ R2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A8 @ A3 )
       => ( ord_less_eq @ ( set @ B ) @ ( image @ A @ B @ R4 @ A8 ) @ ( image @ A @ B @ R2 @ A3 ) ) ) ) ).

% Image_mono
thf(fact_201_Collect__subset,axiom,
    ! [A: $tType,A3: set @ A,P: A > $o] :
      ( ord_less_eq @ ( set @ A )
      @ ( collect @ A
        @ ^ [X2: A] :
            ( ( member @ A @ X2 @ A3 )
            & ( P @ X2 ) ) )
      @ A3 ) ).

% Collect_subset
thf(fact_202_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X2: A] :
            ( ( P @ X2 )
           => ( Q @ X2 ) ) ) ) ).

% Collect_mono_iff
thf(fact_203_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y2: set @ A,Z: set @ A] : ( Y2 = Z ) )
      = ( ^ [A7: set @ A,B6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A7 @ B6 )
            & ( ord_less_eq @ ( set @ A ) @ B6 @ A7 ) ) ) ) ).

% set_eq_subset
thf(fact_204_subset__trans,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A,C5: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B3 )
     => ( ( ord_less_eq @ ( set @ A ) @ B3 @ C5 )
       => ( ord_less_eq @ ( set @ A ) @ A3 @ C5 ) ) ) ).

% subset_trans
thf(fact_205_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
         => ( Q @ X5 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_206_subset__refl,axiom,
    ! [A: $tType,A3: set @ A] : ( ord_less_eq @ ( set @ A ) @ A3 @ A3 ) ).

% subset_refl
thf(fact_207_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A7: set @ A,B6: set @ A] :
          ! [T2: A] :
            ( ( member @ A @ T2 @ A7 )
           => ( member @ A @ T2 @ B6 ) ) ) ) ).

% subset_iff
thf(fact_208_equalityD2,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A] :
      ( ( A3 = B3 )
     => ( ord_less_eq @ ( set @ A ) @ B3 @ A3 ) ) ).

% equalityD2
thf(fact_209_equalityD1,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A] :
      ( ( A3 = B3 )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ B3 ) ) ).

% equalityD1
thf(fact_210_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A7: set @ A,B6: set @ A] :
          ! [X2: A] :
            ( ( member @ A @ X2 @ A7 )
           => ( member @ A @ X2 @ B6 ) ) ) ) ).

% subset_eq
thf(fact_211_equalityE,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A] :
      ( ( A3 = B3 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A3 @ B3 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B3 @ A3 ) ) ) ).

% equalityE
thf(fact_212_subsetD,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B3 )
     => ( ( member @ A @ C2 @ A3 )
       => ( member @ A @ C2 @ B3 ) ) ) ).

% subsetD
thf(fact_213_in__mono,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A,X3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B3 )
     => ( ( member @ A @ X3 @ A3 )
       => ( member @ A @ X3 @ B3 ) ) ) ).

% in_mono
thf(fact_214_converse__subset__swap,axiom,
    ! [A: $tType,B: $tType,R2: set @ ( product_prod @ A @ B ),S2: set @ ( product_prod @ B @ A )] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ R2 @ ( converse @ B @ A @ S2 ) )
      = ( ord_less_eq @ ( set @ ( product_prod @ B @ A ) ) @ ( converse @ A @ B @ R2 ) @ S2 ) ) ).

% converse_subset_swap
thf(fact_215_subrelI,axiom,
    ! [B: $tType,A: $tType,R2: set @ ( product_prod @ A @ B ),S2: set @ ( product_prod @ A @ B )] :
      ( ! [X5: A,Y3: B] :
          ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X5 @ Y3 ) @ R2 )
         => ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X5 @ Y3 ) @ S2 ) )
     => ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ R2 @ S2 ) ) ).

% subrelI
thf(fact_216_bot_Oextremum__uniqueI,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( bot_bot @ A ) )
         => ( A2
            = ( bot_bot @ A ) ) ) ) ).

% bot.extremum_uniqueI
thf(fact_217_bot_Oextremum__unique,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( bot_bot @ A ) )
          = ( A2
            = ( bot_bot @ A ) ) ) ) ).

% bot.extremum_unique
thf(fact_218_bot_Oextremum,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A )
     => ! [A2: A] : ( ord_less_eq @ A @ ( bot_bot @ A ) @ A2 ) ) ).

% bot.extremum
thf(fact_219_insert__mono,axiom,
    ! [A: $tType,C5: set @ A,D4: set @ A,A2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ C5 @ D4 )
     => ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ A2 @ C5 ) @ ( insert @ A @ A2 @ D4 ) ) ) ).

% insert_mono
thf(fact_220_subset__insert,axiom,
    ! [A: $tType,X3: A,A3: set @ A,B3: set @ A] :
      ( ~ ( member @ A @ X3 @ A3 )
     => ( ( ord_less_eq @ ( set @ A ) @ A3 @ ( insert @ A @ X3 @ B3 ) )
        = ( ord_less_eq @ ( set @ A ) @ A3 @ B3 ) ) ) ).

% subset_insert
thf(fact_221_subset__insertI,axiom,
    ! [A: $tType,B3: set @ A,A2: A] : ( ord_less_eq @ ( set @ A ) @ B3 @ ( insert @ A @ A2 @ B3 ) ) ).

% subset_insertI
thf(fact_222_subset__insertI2,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A,B2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B3 )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ ( insert @ A @ B2 @ B3 ) ) ) ).

% subset_insertI2
thf(fact_223_subset__singleton__iff,axiom,
    ! [A: $tType,X4: set @ A,A2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ X4 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( X4
          = ( bot_bot @ ( set @ A ) ) )
        | ( X4
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% subset_singleton_iff
thf(fact_224_subset__singletonD,axiom,
    ! [A: $tType,A3: set @ A,X3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( ( A3
          = ( bot_bot @ ( set @ A ) ) )
        | ( A3
          = ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% subset_singletonD
thf(fact_225_restrict__subsD,axiom,
    ! [B: $tType,A: $tType,G2: labeled_graph @ A @ B] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ ( product_prod @ B @ B ) ) ) @ ( labeled_edges @ A @ B @ G2 ) @ ( labeled_edges @ A @ B @ ( restrict @ A @ B @ G2 ) ) )
     => ( G2
        = ( restrict @ A @ B @ G2 ) ) ) ).

% restrict_subsD
thf(fact_226_congruent2I_H,axiom,
    ! [C: $tType,B: $tType,A: $tType,R1: set @ ( product_prod @ A @ A ),R22: set @ ( product_prod @ B @ B ),F: A > B > C] :
      ( ! [Y12: A,Z1: A,Y23: B,Z22: B] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y12 @ Z1 ) @ R1 )
         => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ Y23 @ Z22 ) @ R22 )
           => ( ( F @ Y12 @ Y23 )
              = ( F @ Z1 @ Z22 ) ) ) )
     => ( equiv_congruent2 @ A @ B @ C @ R1 @ R22 @ F ) ) ).

% congruent2I'
thf(fact_227_congruent2D,axiom,
    ! [A: $tType,C: $tType,B: $tType,R1: set @ ( product_prod @ A @ A ),R22: set @ ( product_prod @ B @ B ),F: A > B > C,Y1: A,Z12: A,Y22: B,Z23: B] :
      ( ( equiv_congruent2 @ A @ B @ C @ R1 @ R22 @ F )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y1 @ Z12 ) @ R1 )
       => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ Y22 @ Z23 ) @ R22 )
         => ( ( F @ Y1 @ Y22 )
            = ( F @ Z12 @ Z23 ) ) ) ) ) ).

% congruent2D
thf(fact_228_proj__iff,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),X3: A,Y4: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ X3 @ ( insert @ A @ Y4 @ ( bot_bot @ ( set @ A ) ) ) ) @ A3 )
       => ( ( ( equiv_proj @ A @ A @ R2 @ X3 )
            = ( equiv_proj @ A @ A @ R2 @ Y4 ) )
          = ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y4 ) @ R2 ) ) ) ) ).

% proj_iff
thf(fact_229_refines__equiv__class__eq2,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),S: set @ ( product_prod @ A @ A ),A3: set @ A,A2: A] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ A ) ) @ R @ S )
     => ( ( equiv_equiv @ A @ A3 @ R )
       => ( ( equiv_equiv @ A @ A3 @ S )
         => ( ( image @ A @ A @ S @ ( image @ A @ A @ R @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
            = ( image @ A @ A @ S @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ) ).

% refines_equiv_class_eq2
thf(fact_230_refines__equiv__class__eq,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),S: set @ ( product_prod @ A @ A ),A3: set @ A,A2: A] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ A ) ) @ R @ S )
     => ( ( equiv_equiv @ A @ A3 @ R )
       => ( ( equiv_equiv @ A @ A3 @ S )
         => ( ( image @ A @ A @ R @ ( image @ A @ A @ S @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
            = ( image @ A @ A @ S @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ) ).

% refines_equiv_class_eq
thf(fact_231_congruent2I,axiom,
    ! [C: $tType,B: $tType,A: $tType,A12: set @ A,R1: set @ ( product_prod @ A @ A ),A23: set @ B,R22: set @ ( product_prod @ B @ B ),F: A > B > C] :
      ( ( equiv_equiv @ A @ A12 @ R1 )
     => ( ( equiv_equiv @ B @ A23 @ R22 )
       => ( ! [Y3: A,Z3: A,W: B] :
              ( ( member @ B @ W @ A23 )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ Z3 ) @ R1 )
               => ( ( F @ Y3 @ W )
                  = ( F @ Z3 @ W ) ) ) )
         => ( ! [Y3: B,Z3: B,W: A] :
                ( ( member @ A @ W @ A12 )
               => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ Y3 @ Z3 ) @ R22 )
                 => ( ( F @ W @ Y3 )
                    = ( F @ W @ Z3 ) ) ) )
           => ( equiv_congruent2 @ A @ B @ C @ R1 @ R22 @ F ) ) ) ) ) ).

% congruent2I
thf(fact_232_congruent2__commuteI,axiom,
    ! [B: $tType,A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),F: A > A > B] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ! [Y3: A,Z3: A] :
            ( ( member @ A @ Y3 @ A3 )
           => ( ( member @ A @ Z3 @ A3 )
             => ( ( F @ Y3 @ Z3 )
                = ( F @ Z3 @ Y3 ) ) ) )
       => ( ! [Y3: A,Z3: A,W: A] :
              ( ( member @ A @ W @ A3 )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y3 @ Z3 ) @ R2 )
               => ( ( F @ W @ Y3 )
                  = ( F @ W @ Z3 ) ) ) )
         => ( equiv_congruent2 @ A @ A @ B @ R2 @ R2 @ F ) ) ) ) ).

% congruent2_commuteI
thf(fact_233_subset__equiv__class,axiom,
    ! [A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),B2: A,A2: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( ord_less_eq @ ( set @ A ) @ ( image @ A @ A @ R2 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) @ ( image @ A @ A @ R2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
       => ( ( member @ A @ B2 @ A3 )
         => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R2 ) ) ) ) ).

% subset_equiv_class
thf(fact_234_insert__subsetI,axiom,
    ! [A: $tType,X3: A,A3: set @ A,X4: set @ A] :
      ( ( member @ A @ X3 @ A3 )
     => ( ( ord_less_eq @ ( set @ A ) @ X4 @ A3 )
       => ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ X3 @ X4 ) @ A3 ) ) ) ).

% insert_subsetI
thf(fact_235_subset__emptyI,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ! [X5: A] :
          ~ ( member @ A @ X5 @ A3 )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_emptyI
thf(fact_236_univ__commute,axiom,
    ! [B: $tType,A: $tType,A3: set @ A,R2: set @ ( product_prod @ A @ A ),F: A > B,X3: A] :
      ( ( equiv_equiv @ A @ A3 @ R2 )
     => ( ( equiv_congruent @ A @ B @ R2 @ F )
       => ( ( member @ A @ X3 @ A3 )
         => ( ( bNF_Greatest_univ @ A @ B @ F @ ( equiv_proj @ A @ A @ R2 @ X3 ) )
            = ( F @ X3 ) ) ) ) ) ).

% univ_commute
thf(fact_237_pred__subset__eq,axiom,
    ! [A: $tType,R: set @ A,S: set @ A] :
      ( ( ord_less_eq @ ( A > $o )
        @ ^ [X2: A] : ( member @ A @ X2 @ R )
        @ ^ [X2: A] : ( member @ A @ X2 @ S ) )
      = ( ord_less_eq @ ( set @ A ) @ R @ S ) ) ).

% pred_subset_eq
thf(fact_238_less__eq__set__def,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A7: set @ A,B6: set @ A] :
            ( ord_less_eq @ ( A > $o )
            @ ^ [X2: A] : ( member @ A @ X2 @ A7 )
            @ ^ [X2: A] : ( member @ A @ X2 @ B6 ) ) ) ) ).

% less_eq_set_def
thf(fact_239_pred__subset__eq2,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ A @ B ),S: set @ ( product_prod @ A @ B )] :
      ( ( ord_less_eq @ ( A > B > $o )
        @ ^ [X2: A,Y: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X2 @ Y ) @ R )
        @ ^ [X2: A,Y: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X2 @ Y ) @ S ) )
      = ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ R @ S ) ) ).

% pred_subset_eq2
thf(fact_240_univ__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( bNF_Greatest_univ @ B @ A )
      = ( ^ [F4: B > A,X8: set @ B] :
            ( F4
            @ ( hilbert_Eps @ B
              @ ^ [X2: B] : ( member @ B @ X2 @ X8 ) ) ) ) ) ).

% univ_def
thf(fact_241_ssubst__Pair__rhs,axiom,
    ! [B: $tType,A: $tType,R2: A,S2: B,R: set @ ( product_prod @ A @ B ),S3: B] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ R2 @ S2 ) @ R )
     => ( ( S3 = S2 )
       => ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ R2 @ S3 ) @ R ) ) ) ).

% ssubst_Pair_rhs
thf(fact_242_subset__Collect__iff,axiom,
    ! [A: $tType,B3: set @ A,A3: set @ A,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ B3 @ A3 )
     => ( ( ord_less_eq @ ( set @ A ) @ B3
          @ ( collect @ A
            @ ^ [X2: A] :
                ( ( member @ A @ X2 @ A3 )
                & ( P @ X2 ) ) ) )
        = ( ! [X2: A] :
              ( ( member @ A @ X2 @ B3 )
             => ( P @ X2 ) ) ) ) ) ).

% subset_Collect_iff
thf(fact_243_subset__CollectI,axiom,
    ! [A: $tType,B3: set @ A,A3: set @ A,Q: A > $o,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ B3 @ A3 )
     => ( ! [X5: A] :
            ( ( member @ A @ X5 @ B3 )
           => ( ( Q @ X5 )
             => ( P @ X5 ) ) )
       => ( ord_less_eq @ ( set @ A )
          @ ( collect @ A
            @ ^ [X2: A] :
                ( ( member @ A @ X2 @ B3 )
                & ( Q @ X2 ) ) )
          @ ( collect @ A
            @ ^ [X2: A] :
                ( ( member @ A @ X2 @ A3 )
                & ( P @ X2 ) ) ) ) ) ) ).

% subset_CollectI
thf(fact_244_Collect__restrict,axiom,
    ! [A: $tType,X4: set @ A,P: A > $o] :
      ( ord_less_eq @ ( set @ A )
      @ ( collect @ A
        @ ^ [X2: A] :
            ( ( member @ A @ X2 @ X4 )
            & ( P @ X2 ) ) )
      @ X4 ) ).

% Collect_restrict
thf(fact_245_prop__restrict,axiom,
    ! [A: $tType,X3: A,Z4: set @ A,X4: set @ A,P: A > $o] :
      ( ( member @ A @ X3 @ Z4 )
     => ( ( ord_less_eq @ ( set @ A ) @ Z4
          @ ( collect @ A
            @ ^ [X2: A] :
                ( ( member @ A @ X2 @ X4 )
                & ( P @ X2 ) ) ) )
       => ( P @ X3 ) ) ) ).

% prop_restrict
thf(fact_246_graph__unionI,axiom,
    ! [B: $tType,A: $tType,G_1: labeled_graph @ A @ B,G_2: labeled_graph @ A @ B] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ ( product_prod @ B @ B ) ) ) @ ( labeled_edges @ A @ B @ G_1 ) @ ( labeled_edges @ A @ B @ G_2 ) )
     => ( ( ord_less_eq @ ( set @ B ) @ ( labeled_vertices @ A @ B @ G_1 ) @ ( labeled_vertices @ A @ B @ G_2 ) )
       => ( ( graph_union @ A @ B @ G_1 @ G_2 )
          = G_2 ) ) ) ).

% graph_unionI
thf(fact_247_less__by__empty,axiom,
    ! [A: $tType,A3: set @ ( product_prod @ A @ A ),B3: set @ ( product_prod @ A @ A )] :
      ( ( A3
        = ( bot_bot @ ( set @ ( product_prod @ A @ A ) ) ) )
     => ( ord_less_eq @ ( set @ ( product_prod @ A @ A ) ) @ A3 @ B3 ) ) ).

% less_by_empty
thf(fact_248_predicate2I,axiom,
    ! [B: $tType,A: $tType,P: A > B > $o,Q: A > B > $o] :
      ( ! [X5: A,Y3: B] :
          ( ( P @ X5 @ Y3 )
         => ( Q @ X5 @ Y3 ) )
     => ( ord_less_eq @ ( A > B > $o ) @ P @ Q ) ) ).

% predicate2I
thf(fact_249_predicate1I,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
         => ( Q @ X5 ) )
     => ( ord_less_eq @ ( A > $o ) @ P @ Q ) ) ).

% predicate1I
thf(fact_250_graph__union__idemp_I1_J,axiom,
    ! [B: $tType,A: $tType,A3: labeled_graph @ A @ B] :
      ( ( graph_union @ A @ B @ A3 @ A3 )
      = A3 ) ).

% graph_union_idemp(1)
thf(fact_251_graph__union__idemp_I2_J,axiom,
    ! [B: $tType,A: $tType,A3: labeled_graph @ A @ B,B3: labeled_graph @ A @ B] :
      ( ( graph_union @ A @ B @ A3 @ ( graph_union @ A @ B @ A3 @ B3 ) )
      = ( graph_union @ A @ B @ A3 @ B3 ) ) ).

% graph_union_idemp(2)
thf(fact_252_graph__union__idemp_I3_J,axiom,
    ! [B: $tType,A: $tType,A3: labeled_graph @ A @ B,B3: labeled_graph @ A @ B] :
      ( ( graph_union @ A @ B @ A3 @ ( graph_union @ A @ B @ B3 @ A3 ) )
      = ( graph_union @ A @ B @ B3 @ A3 ) ) ).

% graph_union_idemp(3)
thf(fact_253_graph__union__preserves__restrict,axiom,
    ! [B: $tType,A: $tType,G_1: labeled_graph @ A @ B,G_2: labeled_graph @ A @ B] :
      ( ( G_1
        = ( restrict @ A @ B @ G_1 ) )
     => ( ( G_2
          = ( restrict @ A @ B @ G_2 ) )
       => ( ( graph_union @ A @ B @ G_1 @ G_2 )
          = ( restrict @ A @ B @ ( graph_union @ A @ B @ G_1 @ G_2 ) ) ) ) ) ).

% graph_union_preserves_restrict
thf(fact_254_rev__predicate2D,axiom,
    ! [A: $tType,B: $tType,P: A > B > $o,X3: A,Y4: B,Q: A > B > $o] :
      ( ( P @ X3 @ Y4 )
     => ( ( ord_less_eq @ ( A > B > $o ) @ P @ Q )
       => ( Q @ X3 @ Y4 ) ) ) ).

% rev_predicate2D
thf(fact_255_rev__predicate1D,axiom,
    ! [A: $tType,P: A > $o,X3: A,Q: A > $o] :
      ( ( P @ X3 )
     => ( ( ord_less_eq @ ( A > $o ) @ P @ Q )
       => ( Q @ X3 ) ) ) ).

% rev_predicate1D

% Type constructors (16)
thf(tcon_fun___Orderings_Oorder__bot,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( order_bot @ A10 )
     => ( order_bot @ ( A9 > A10 ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( preorder @ A10 )
     => ( preorder @ ( A9 > A10 ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( order @ A10 )
     => ( order @ ( A9 > A10 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( ord @ A10 )
     => ( ord @ ( A9 > A10 ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A9: $tType,A10: $tType] :
      ( ( bot @ A10 )
     => ( bot @ ( A9 > A10 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder__bot_1,axiom,
    ! [A9: $tType] : ( order_bot @ ( set @ A9 ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_2,axiom,
    ! [A9: $tType] : ( preorder @ ( set @ A9 ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_3,axiom,
    ! [A9: $tType] : ( order @ ( set @ A9 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_4,axiom,
    ! [A9: $tType] : ( ord @ ( set @ A9 ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_5,axiom,
    ! [A9: $tType] : ( bot @ ( set @ A9 ) ) ).

thf(tcon_HOL_Obool___Orderings_Oorder__bot_6,axiom,
    order_bot @ $o ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_8,axiom,
    order @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_9,axiom,
    ord @ $o ).

thf(tcon_HOL_Obool___Orderings_Obot_10,axiom,
    bot @ $o ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X3: A,Y4: A] :
      ( ( if @ A @ $false @ X3 @ Y4 )
      = Y4 ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X3: A,Y4: A] :
      ( ( if @ A @ $true @ X3 @ Y4 )
      = X3 ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ( ( hilbert_Eps @ b
      @ ^ [Y: b] : ( member @ b @ Y @ ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ x @ ( bot_bot @ ( set @ b ) ) ) ) ) )
    = ( hilbert_Eps @ b
      @ ^ [Y: b] : ( member @ b @ Y @ ( image @ b @ b @ ( getRel @ ( standard_Constant @ a ) @ b @ ( standard_S_Idt @ a ) @ g ) @ ( insert @ b @ y @ ( bot_bot @ ( set @ b ) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
